#!/bin/bash
set -e

if [ ! -f /var/app/.initialized ]; then
    ######## First Time ########

    echo "First run. Setting up ..."
    mkdir -p /var/app
    touch /var/app/.initialized

    # ユーザーが存在しない場合のみ作成する
    if id "${UNAME}" &>/dev/null; then
        echo "User ${UNAME} already exists. Skipping creation."
    else
        # 同名グループが無ければ作成する
        if ! getent group "${UNAME}" &>/dev/null; then
            echo "Creating group ${UNAME} with GID=${GID}"
            groupadd -g ${GID} ${UNAME}
        else
            echo "Group ${UNAME} already exists. Skipping group creation."
        fi
    
        echo "Creating user ${UNAME} with UID=${UID}, GID=${GID}"
        useradd -m -u ${UID} -g ${GID} -s /bin/bash ${UNAME}
        echo "${UNAME}:${PASS}" | chpasswd
        usermod -aG sudo ${UNAME}
    fi

    # ホームディレクトリの Owner が root:root になることがあるので明示的に変更する。
    chown -v ${UNAME}:${UNAME}  /home/${UNAME}

    # SSHD のポート番号を変更する
    sed -i "s/^Port.*/Port ${SSHD_PORT}/" /etc/ssh/sshd_config

    
else
    ######## Second Time or Later ########
    
    echo "Starting for the second time or later ..."

fi

# supervisord start (background)
/usr/bin/supervisord -c /etc/supervisor/supervisord.conf &

# Execute Commands in CMD

if [ "$#" -gt 0 ]; then
    exec "$@"
else
    echo "No command provided. Starting bash ..."
    exec bash
fi
